/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import immersive_armors.client.render.entity.model.CapeModel;
import immersive_armors.client.render.entity.piece.Piece;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;

public class CapePiece<M extends CapeModel<class_1309>>
extends Piece {
    private final M model;

    public CapePiece(M model) {
        this.model = model;
    }

    private class_2960 getCapeTexture(ExtendedArmorItem item, boolean overlay) {
        return new class_2960("immersive_armors", "textures/models/armor/" + item.getMaterial().method_7694() + "/cape" + (overlay ? "_overlay" : "") + ".png");
    }

    private class_243 predictPosition(class_1297 entity, float tickDelta) {
        return new class_243(class_3532.method_16436((double)tickDelta, (double)entity.field_6014, (double)entity.method_23317()), class_3532.method_16436((double)tickDelta, (double)entity.field_6036, (double)entity.method_23318()), class_3532.method_16436((double)tickDelta, (double)entity.field_5969, (double)entity.method_23321()));
    }

    @Override
    public <T extends class_1309, A extends class_572<T>> void render(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, class_1799 itemStack, float tickDelta, class_1304 armorSlot, A armorModel) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof ExtendedArmorItem) {
            class_4588 vertexConsumer;
            ExtendedArmorItem armor = (ExtendedArmorItem)class_17922;
            CapeAngles angles = new CapeAngles(itemStack);
            angles.updateCapeAngles((class_1297)entity, tickDelta);
            angles.store(itemStack);
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 0.125);
            float n = entity.field_6220 + (entity.field_6283 - entity.field_6220);
            double o = class_3532.method_15374((float)(n * ((float)Math.PI / 180)));
            double p = -class_3532.method_15362((float)(n * ((float)Math.PI / 180)));
            double q = angles.deltaY * 40.0;
            q = class_3532.method_15350((double)q, (double)-6.0, (double)32.0);
            double r = (angles.deltaX * o + angles.deltaZ * p) * 100.0;
            r = class_3532.method_15350((double)r, (double)0.0, (double)150.0);
            double s = (angles.deltaX * p - angles.deltaZ * o) * 100.0;
            s = class_3532.method_15350((double)s, (double)-20.0, (double)20.0);
            if (r < 0.0) {
                r = 0.0;
            }
            if (entity.method_18276()) {
                q += 22.5;
                matrices.method_22904(0.0, 0.25, 0.0);
            }
            matrices.method_22907(class_1160.field_20703.method_23214((float)(6.0 + r / 2.0 + q)));
            matrices.method_22907(class_1160.field_20707.method_23214((float)(s / 2.0)));
            matrices.method_22907(class_1160.field_20705.method_23214((float)(180.0 - s / 2.0)));
            ((CapeModel)((Object)this.model)).setAngles(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (this.isColored()) {
                int i = ((class_1768)armor).method_7800(itemStack);
                float red = (float)(i >> 16 & 0xFF) / 255.0f;
                float green = (float)(i >> 8 & 0xFF) / 255.0f;
                float blue = (float)(i & 0xFF) / 255.0f;
                vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448((class_2960)this.getCapeTexture(armor, false)));
                ((CapeModel)((Object)this.model)).method_2828(matrices, vertexConsumer, light, class_4608.field_21444, red, green, blue, 1.0f);
                vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448((class_2960)this.getCapeTexture(armor, true)));
            } else {
                vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448((class_2960)this.getCapeTexture(armor, false)));
            }
            ((CapeModel)((Object)this.model)).method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            matrices.method_22909();
        }
    }

    private class CapeAngles {
        private double capeX;
        private double capeY;
        private double capeZ;
        private double deltaX;
        private double deltaY;
        private double deltaZ;
        private float lastTickDelta;

        private void updateCapeAngles(class_1297 entity, float tickDelta) {
            float delta;
            class_243 pos = CapePiece.this.predictPosition(entity, tickDelta);
            double deltaX = pos.method_10216() - this.capeX;
            double deltaY = pos.method_10214() - this.capeY;
            double deltaZ = pos.method_10215() - this.capeZ;
            if (deltaX > 10.0 || deltaX < -10.0) {
                this.capeX = pos.method_10216();
                deltaX = 0.0;
            }
            if (deltaY > 10.0 || deltaY < -10.0) {
                this.capeY = pos.method_10214();
                deltaY = 0.0;
            }
            if (deltaZ > 10.0 || deltaZ < -10.0) {
                this.capeZ = pos.method_10215();
                deltaZ = 0.0;
            }
            if ((double)(delta = tickDelta - this.lastTickDelta) < 0.0) {
                delta = 1.0f + delta;
            }
            this.lastTickDelta = tickDelta;
            this.capeX += deltaX * (double)(delta *= 0.25f);
            this.capeZ += deltaZ * (double)delta;
            this.capeY += deltaY * (double)delta;
            this.deltaX = this.capeX - pos.method_10216();
            this.deltaY = this.capeY - pos.method_10214();
            this.deltaZ = this.capeZ - pos.method_10215();
        }

        public CapeAngles(class_1799 cape) {
            class_2487 tag = cape.method_7948();
            if (tag.method_10545("capeAngles")) {
                class_2487 angles = tag.method_10562("capeAngles");
                this.capeX = angles.method_10574("capeX");
                this.capeY = angles.method_10574("capeY");
                this.capeZ = angles.method_10574("capeZ");
                this.lastTickDelta = angles.method_10583("lastTickDelta");
            }
        }

        public void store(class_1799 cape) {
            class_2487 tag = cape.method_7948();
            class_2487 angles = new class_2487();
            angles.method_10549("capeX", this.capeX);
            angles.method_10549("capeY", this.capeY);
            angles.method_10549("capeZ", this.capeZ);
            angles.method_10548("lastTickDelta", this.lastTickDelta);
            tag.method_10566("capeAngles", (class_2520)angles);
        }
    }
}

